def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        gripper = 'gripper'  # Placeholder for the gripper object
        drawer = 'drawer'    # Placeholder for the drawer object
        object_to_pick = 'object'  # Placeholder for the object to pick
        side_position = 'side_pos'  # Placeholder for the side position
        anchor_position = 'anchor_pos'  # Placeholder for the anchor position

        # Step 1: Move to the side position of the drawer
        print("[Task] Moving to side position of the drawer.")
        move(env, gripper, positions[gripper], positions[side_position])

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        pick_door(env, gripper, drawer, positions[anchor_position])

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        pull(env, gripper, drawer)

        # Step 4: Place the object in the drawer
        print("[Task] Placing the object in the drawer.")
        place(env, object_to_pick, positions[drawer])

    except Exception as e:
        print(f"An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()