def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'     # Placeholder for the actual drawer object
        initial_position = 'room_a'  # Placeholder for the initial position of the robot

        # Move to the initial position
        print("[Task] Moving to initial position:", initial_position)
        move(env, initial_position, 'room_a')

        # Pick the drawer
        print("[Task] Picking the drawer at position:", positions[drawer])
        pick(env, drawer, positions[drawer], gripper)

        # Rotate the gripper to the required angle
        print("[Task] Rotating gripper to ninety degrees.")
        rotate(env, gripper, 'zero_deg', 'ninety_deg')

        # Move to the side position of the drawer
        side_position = 'side_pos_1'  # Placeholder for the actual side position
        print("[Task] Moving to side position:", side_position)
        move_to_side(env, gripper, drawer, 'current_pos', side_position)

        # Pull the drawer
        print("[Task] Pulling the drawer.")
        pull(env, gripper, drawer)

        # Place the object (if needed)
        print("[Task] Placing the object.")
        place(env, drawer, 'final_position')  # Placeholder for the final position

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()