def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'  # Placeholder for the actual drawer object
        object_to_pick = 'object'  # Placeholder for the actual object to pick
        initial_position = positions['initial_position']  # Replace with actual position key
        side_position = positions['side_position']  # Replace with actual side position key
        anchor_position = positions['anchor_position']  # Replace with actual anchor position key

        # Step 1: Move to the initial position
        print("[Task] Moving to initial position.")
        move(env, initial_position, initial_position)

        # Step 2: Pick the object
        print("[Task] Picking the object.")
        pick(env, object_to_pick, initial_position, gripper)

        # Step 3: Move to the side position
        print("[Task] Moving to side position.")
        move(env, initial_position, side_position)

        # Step 4: Move to the anchor position
        print("[Task] Moving to anchor position.")
        move(env, side_position, anchor_position)

        # Step 5: Place the object
        print("[Task] Placing the object.")
        place(env, object_to_pick, anchor_position)

        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()