def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these with actual object names from your environment
        robot_position = positions['robot']
        object_position = positions['object']  # Replace with actual object key
        drawer_position = positions['drawer']  # Replace with actual drawer key

        # Step 1: Move to the object's location
        print("[Task] Moving to the object's location:", object_position)
        move(env, robot_position, object_position)

        # Step 2: Pick the object
        print("[Task] Picking the object at:", object_position)
        pick(env, 'object', object_position, 'gripper')  # Replace 'object' and 'gripper' with actual names

        # Step 3: Move to the drawer's location
        print("[Task] Moving to the drawer's location:", drawer_position)
        move(env, object_position, drawer_position)

        # Step 4: Place the object in the drawer
        print("[Task] Placing the object in the drawer at:", drawer_position)
        place(env, 'object', drawer_position)  # Replace 'object' with actual object name

        # Step 5: Open the drawer (if needed)
        print("[Task] Opening the drawer.")
        pull(env, 'gripper', 'drawer')  # Replace 'gripper' and 'drawer' with actual names

        # Complete the task
        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()