import numpy as np
from env import setup_environment, shutdown_environment
from skill_code import *  
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    print("===== Starting Skeleton Task =====")
    
    env, task = setup_environment()
    try:
        descriptions, obs = task.reset()
        init_video_writers(obs)

        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        positions = get_object_positions()
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        plate_pos = positions['plate']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']

        obs, reward, done = rotate(env, task, target_quat=np.array([0, 0, 1, 0]), max_steps=100, threshold=0.05, timeout=10.0)
        if done: return

        obs, reward, done = move(env, task, target_pos=bottom_side_pos, max_steps=100, threshold=0.01, timeout=10.0)
        if done: return

        obs, reward, done = move(env, task, target_pos=bottom_anchor_pos, max_steps=100, threshold=0.01, timeout=10.0)
        if done: return

        obs, reward, done = pick_drawer(env, task, gripper='gripper', d='bottom', p=bottom_anchor_pos)
        if done: return

        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='x', max_steps=100, threshold=0.01, timeout=10.0)
        if done: return

        obs, reward, done = pick(env, task, target_pos=tomato1_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
        if done: return

        obs, reward, done = place(env, task, target_pos=plate_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
        if done: return

        obs, reward, done = pick(env, task, target_pos=tomato2_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
        if done: return

        obs, reward, done = place(env, task, target_pos=plate_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()