import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *  # Importing predefined skills
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        top_drawer_pos = positions['top_anchor_pos']
        table_pos = positions['plate']
        tomato1_pos = positions['item1']
        tomato2_pos = positions['item2']

        # === Task Plan Execution ===
        # Step 1: Pull the top drawer to unlock it
        print("[Task] Unlocking the cabinet by opening the top drawer.")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
        if done:
            print("[Task] Drawer opened successfully!")
        else:
            print("[Task] Failed to open the drawer.")

        # Step 2: Pick the first tomato
        print("[Task] Picking the first tomato.")
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] First tomato picked successfully!")
        else:
            print("[Task] Failed to pick the first tomato.")

        # Step 3: Place the first tomato on the plate
        print("[Task] Placing the first tomato on the plate.")
        obs, reward, done = place(env, task, target_pos=table_pos)
        if done:
            print("[Task] First tomato placed successfully!")
        else:
            print("[Task] Failed to place the first tomato.")

        # Step 4: Pick the second tomato
        print("[Task] Picking the second tomato.")
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Second tomato picked successfully!")
        else:
            print("[Task] Failed to pick the second tomato.")

        # Step 5: Place the second tomato on the plate
        print("[Task] Placing the second tomato on the plate.")
        obs, reward, done = place(env, task, target_pos=table_pos)
        if done:
            print("[Task] Second tomato placed successfully!")
        else:
            print("[Task] Failed to place the second tomato.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()