import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        plate_pos = positions['plate']
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        bottom_anchor_pos = positions['bottom_anchor_pos']

        # Step 1: Open one of the drawers (pull action)
        print("[Task] Opening the top drawer.")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
        if done:
            print("[Task] Drawer opened successfully!")
        else:
            print("[Task] Failed to open the drawer.")

        # Step 2: Place all tomatoes on the plate
        print("[Task] Picking tomato1.")
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Picked tomato1 successfully!")
            print("[Task] Placing tomato1 on the plate.")
            obs, reward, done = place(env, task, target_pos=plate_pos)
            if done:
                print("[Task] Placed tomato1 on the plate successfully!")
            else:
                print("[Task] Failed to place tomato1 on the plate.")
        else:
            print("[Task] Failed to pick tomato1.")

        print("[Task] Picking tomato2.")
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Picked tomato2 successfully!")
            print("[Task] Placing tomato2 on the plate.")
            obs, reward, done = place(env, task, target_pos=plate_pos)
            if done:
                print("[Task] Placed tomato2 on the plate successfully!")
            else:
                print("[Task] Failed to place tomato2 on the plate.")
        else:
            print("[Task] Failed to pick tomato2.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()