import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        item1_pos = positions['tomato1']
        item2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # === Execute the Plan ===
        # Step 1: Pick item1
        print("[Task] Picking item1...")
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 2: Place item1 on the plate
        print("[Task] Placing item1 on the plate...")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after placing item1!")
            return

        # Step 3: Pick item2
        print("[Task] Picking item2...")
        obs, reward, done = pick(env, task, target_pos=item2_pos)
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 4: Place item2 on the plate
        print("[Task] Placing item2 on the plate...")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after placing item2!")
            return

        print("[Task] All items have been successfully placed on the plate!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()