def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a plate and tomatoes in the environment
        plate_position = positions['plate']
        tomato_positions = [positions[f'tomato_{i}'] for i in range(1, 4)]  # Assuming 3 tomatoes

        # Step 1: Move to each tomato and pick it up
        for tomato_position in tomato_positions:
            print(f"[Task] Moving to tomato at: {tomato_position}")
            obs, reward, done = move(env, task, obs.gripper_pose[:3], tomato_position)
            if done:
                print("[Task] Task ended during movement!")
                return

            print(f"[Task] Picking up tomato at: {tomato_position}")
            obs, reward, done = pick(env, task, tomato_position)
            if done:
                print("[Task] Task ended during picking!")
                return

            # Step 2: Move to the plate and place the tomato
            print(f"[Task] Moving to plate at: {plate_position}")
            obs, reward, done = move(env, task, obs.gripper_pose[:3], plate_position)
            if done:
                print("[Task] Task ended during movement to plate!")
                return

            print(f"[Task] Placing tomato on plate at: {plate_position}")
            obs, reward, done = place(env, task, plate_position)
            if done:
                print("[Task] Task ended during placing!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()