def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named 'ball1' and 'rooma' in the environment
        ball1_pos = positions['ball1']
        rooma_pos = positions['rooma']

        # Step 1: Move to the location of the ball
        print("[Task] Moving to the location of ball1 at:", ball1_pos)
        obs, reward, done = move(env, 'rooma', 'ball1')
        if done:
            print("[Task] Task ended after moving to ball1!")
            return

        # Step 2: Pick up the ball
        print("[Task] Picking up ball1...")
        obs, reward, done = pick(env, task, target_pos=ball1_pos)
        if done:
            print("[Task] Task ended after picking up ball1!")
            return

        # Step 3: Move to the drop location (assuming 'roomb' is the drop location)
        print("[Task] Moving to the drop location (roomb)...")
        obs, reward, done = move(env, 'ball1', 'roomb')
        if done:
            print("[Task] Task ended after moving to roomb!")
            return

        # Step 4: Place the ball down
        print("[Task] Placing ball1 in roomb...")
        obs, reward, done = place(env, task, target_pos=roomb_pos)
        if done:
            print("[Task] Task ended after placing ball1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()