def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have one object to pick and a location to place it
        object_pos = positions['object_1']  # Replace with actual object key
        drop_pos = positions['drop_location']  # Replace with actual drop location key

        # Step 1: Move to the object
        print("[Task] Moving to object at:", object_pos)
        obs, reward, done = move(env, 'current_room', 'object_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to object!")
            return

        # Step 2: Pick the object
        print("[Task] Picking object at:", object_pos)
        obs, reward, done = pick(env, task, target_pos=object_pos)
        if done:
            print("[Task] Task ended after picking object!")
            return

        # Step 3: Move to the drop location
        print("[Task] Moving to drop location at:", drop_pos)
        obs, reward, done = move(env, 'object_room', 'drop_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended while moving to drop location!")
            return

        # Step 4: Place the object
        print("[Task] Placing object at:", drop_pos)
        obs, reward, done = place(env, task, target_pos=drop_pos)
        if done:
            print("[Task] Task ended after placing object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()