def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball object to pick and a room to place it in
        ball_pos = positions['ball1']  # Replace with actual object name
        room_pos = positions['rooma']   # Replace with actual room name

        # Step 1: Move to the ball's location
        print("[Task] Moving to the ball's location:", ball_pos)
        obs, reward, done = move(env, task, obs.robot_position, ball_pos)
        if done:
            print("[Task] Task ended while moving to the ball!")
            return

        # Step 2: Pick the ball
        print("[Task] Picking the ball at:", ball_pos)
        obs, reward, done = pick(env, task, target_pos=ball_pos)
        if done:
            print("[Task] Task ended while picking the ball!")
            return

        # Step 3: Move to the room's location
        print("[Task] Moving to the room's location:", room_pos)
        obs, reward, done = move(env, task, obs.robot_position, room_pos)
        if done:
            print("[Task] Task ended while moving to the room!")
            return

        # Step 4: Place the ball in the room
        print("[Task] Placing the ball in the room at:", room_pos)
        obs, reward, done = place(env, task, target_pos=room_pos)
        if done:
            print("[Task] Task ended while placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()