def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']
        table_pos = positions['table']
        plate_pos = positions['plate']

        # === Task Plan Execution ===
        # Step 1: Move to tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, from_room=table_pos, to_room=tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick up tomato1
        print("[Task] Picking up tomato1...")
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 3: Move to plate
        print("[Task] Moving to plate at:", plate_pos)
        obs, reward, done = move(env, task, from_room=tomato1_pos, to_room=plate_pos)
        if done:
            print("[Task] Task ended after moving to plate!")
            return

        # Step 4: Place tomato1 on plate
        print("[Task] Placing tomato1 on plate...")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after placing tomato1 on plate!")
            return

        # Step 5: Move to tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, from_room=plate_pos, to_room=tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 6: Pick up tomato2
        print("[Task] Picking up tomato2...")
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 7: Move to rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, from_room=tomato2_pos, to_room=rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 8: Place tomato2 in rubbish
        print("[Task] Placing tomato2 in rubbish...")
        obs, reward, done = place(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after placing tomato2 in rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()