def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named 'ball1' and 'ball2' in the environment
        ball1_pos = positions['ball1']
        ball2_pos = positions['ball2']
        robot_pos = positions['robot']

        # Check if the robot is at the initial position
        if not obs.robot_at(robot_pos):
            print("[Task] Moving robot to initial position...")
            move(env, robot_pos, robot_pos)  # Move to the initial position

        # Pick up ball1
        if 'ball1' in positions:
            print("[Task] Picking up ball1 at:", ball1_pos)
            obs, reward, done = pick(env, task, target_pos=ball1_pos)
            if done:
                print("[Task] Task ended after picking ball1!")
                return
        else:
            print("[Task] ball1 not found in the environment.")

        # Place ball1 in a new location (e.g., ball2's position)
        if 'ball2' in positions:
            print("[Task] Placing ball1 at ball2's position:", ball2_pos)
            obs, reward, done = place(env, task, target_pos=ball2_pos)
            if done:
                print("[Task] Task ended after placing ball1!")
                return
        else:
            print("[Task] ball2 not found in the environment.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()