def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'ball1' and 'ball2' and are located in 'rooma'
        ball1_pos = positions['ball1']
        ball2_pos = positions['ball2']
        rooma_pos = positions['rooma']

        # Step 1: Move to ball1
        print("[Task] Moving to ball1 at:", ball1_pos)
        obs, reward, done = move(env, 'rooma', ball1_pos)
        if done:
            print("[Task] Task ended after moving to ball1!")
            return

        # Step 2: Pick ball1
        print("[Task] Picking ball1")
        obs, reward, done = pick(env, 'ball1', 'rooma')
        if done:
            print("[Task] Task ended after picking ball1!")
            return

        # Step 3: Move to the drop location (e.g., rubbish)
        drop_location = positions['rubbish']  # Assuming rubbish is a valid drop location
        print("[Task] Moving to drop location at:", drop_location)
        obs, reward, done = move(env, ball1_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 4: Place ball1 in the drop location
        print("[Task] Placing ball1")
        obs, reward, done = place(env, 'ball1', drop_location)
        if done:
            print("[Task] Task ended after placing ball1!")
            return

        # Step 5: Move to ball2
        print("[Task] Moving to ball2 at:", ball2_pos)
        obs, reward, done = move(env, 'rooma', ball2_pos)
        if done:
            print("[Task] Task ended after moving to ball2!")
            return

        # Step 6: Pick ball2
        print("[Task] Picking ball2")
        obs, reward, done = pick(env, 'ball2', 'rooma')
        if done:
            print("[Task] Task ended after picking ball2!")
            return

        # Step 7: Move to the drop location again
        print("[Task] Moving to drop location at:", drop_location)
        obs, reward, done = move(env, ball2_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 8: Place ball2 in the drop location
        print("[Task] Placing ball2")
        obs, reward, done = place(env, 'ball2', drop_location)
        if done:
            print("[Task] Task ended after placing ball2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()