def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects: object_1 and object_2
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']
        robot_pos = positions['robot']

        # 1) Move to object_1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, robot_pos, object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # 2) Pick object_1
        print("[Task] Picking object_1...")
        obs, reward, done = pick(env, 'object_1', object_1_pos)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # 3) Move to the target location (e.g., a plate)
        target_location = positions['target_location']
        print("[Task] Moving to target location at:", target_location)
        obs, reward, done = move(env, object_1_pos, target_location)
        if done:
            print("[Task] Task ended after moving to target location!")
            return

        # 4) Place object_1 on the target location
        print("[Task] Placing object_1 on the target location...")
        obs, reward, done = place(env, task, target_pos=target_location)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # 5) Move to object_2
        print("[Task] Moving to object_2 at:", object_2_pos)
        obs, reward, done = move(env, target_location, object_2_pos)
        if done:
            print("[Task] Task ended after moving to object_2!")
            return

        # 6) Pick object_2
        print("[Task] Picking object_2...")
        obs, reward, done = pick(env, 'object_2', object_2_pos)
        if done:
            print("[Task] Task ended after picking object_2!")
            return

        # 7) Move back to the target location
        print("[Task] Moving back to target location at:", target_location)
        obs, reward, done = move(env, object_2_pos, target_location)
        if done:
            print("[Task] Task ended after moving back to target location!")
            return

        # 8) Place object_2 on the target location
        print("[Task] Placing object_2 on the target location...")
        obs, reward, done = place(env, task, target_pos=target_location)
        if done:
            print("[Task] Task ended after placing object_2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()