def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named 'item1', 'item2', 'item3'
        object_1_pos = positions.get('item1')
        object_2_pos = positions.get('item2')
        object_3_pos = positions.get('item3')

        # Check if objects are present before manipulating
        if object_1_pos is not None:
            print("[Task] Manipulating item1 at:", object_1_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating item1!")
                return
        else:
            print("Error: item1 not found in the environment.")

        if object_2_pos is not None:
            print("[Task] Manipulating item2 at:", object_2_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating item2!")
                return
        else:
            print("Error: item2 not found in the environment.")

        if object_3_pos is not None:
            print("[Task] Manipulating item3 at:", object_3_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=object_3_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating item3!")
                return
        else:
            print("Error: item3 not found in the environment.")

        # Example of placing the objects after picking them
        if obs and not done:
            print("[Task] Placing item1 back to its original position.")
            obs, reward, done = place(
                env,
                task,
                target_pos=object_1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after placing item1!")
                return

            print("[Task] Placing item2 back to its original position.")
            obs, reward, done = place(
                env,
                task,
                target_pos=object_2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after placing item2!")
                return

            print("[Task] Placing item3 back to its original position.")
            obs, reward, done = place(
                env,
                task,
                target_pos=object_3_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after placing item3!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()