def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects: 'tomato1' and 'tomato2'
        tomato1_pos = positions.get('tomato1')
        tomato2_pos = positions.get('tomato2')

        # Check if both tomatoes are present
        if tomato1_pos is None:
            print("Error: 'tomato1' object not found in the environment.")
            return
        if tomato2_pos is None:
            print("Error: 'tomato2' object not found in the environment.")
            return

        # Step 1: Pick up the first tomato
        print("[Task] Manipulating tomato1 at:", tomato1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating tomato1!")
            return

        # Step 2: Place the first tomato down (assuming we have a plate position)
        plate_pos = positions.get('plate')
        if plate_pos is None:
            print("Error: 'plate' object not found in the environment.")
            return

        print("[Task] Placing tomato1 on plate at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos
        )
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Step 3: Pick up the second tomato
        print("[Task] Manipulating tomato2 at:", tomato2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating tomato2!")
            return

        # Step 4: Place the second tomato down
        print("[Task] Placing tomato2 on plate at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos
        )
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()