def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']
        
        # Check if the objects are present before attempting to pick them
        if 'tomato1' in obs.get_objects():
            print("[Task] Manipulating tomato1 at:", tomato1_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating tomato1!")
                return
        else:
            print("Target object tomato1 not found on the table")
            return

        if 'tomato2' in obs.get_objects():
            print("[Task] Manipulating tomato2 at:", tomato2_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating tomato2!")
                return
        else:
            print("Target object tomato2 not found on the table")
            return

        if 'rubbish' in obs.get_objects():
            print("[Task] Manipulating rubbish at:", rubbish_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=rubbish_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after manipulating rubbish!")
                return
        else:
            print("Target object rubbish not found on the table")
            return

        # Place the objects in their designated locations
        print("[Task] Placing tomato1 back on the table.")
        obs, reward, done = place(env, task, target_pos=positions['table'], object='tomato1')
        if done:
            print("[Task] Successfully placed tomato1!")

        print("[Task] Placing tomato2 back on the table.")
        obs, reward, done = place(env, task, target_pos=positions['table'], object='tomato2')
        if done:
            print("[Task] Successfully placed tomato2!")

        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, task, target_pos=positions['bin'], object='rubbish')
        if done:
            print("[Task] Successfully placed rubbish in the bin!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()