def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'rubbish' to pick and a location 'rooma'
        rubbish_pos = positions['rubbish']
        rooma_pos = positions['rooma']

        # 1) Move to the location of the rubbish
        print("[Task] Moving to the rubbish location at:", rubbish_pos)
        obs, reward, done = move(env, task, from_room=rooma_pos, to_room=rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish location!")
            return

        # 2) Pick the rubbish
        print("[Task] Picking up the rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return

        # 3) Move to the disposal location (assuming it's 'roomb')
        disposal_pos = positions['roomb']
        print("[Task] Moving to the disposal location at:", disposal_pos)
        obs, reward, done = move(env, task, from_room=rubbish_pos, to_room=disposal_pos)
        if done:
            print("[Task] Task ended after moving to disposal location!")
            return

        # 4) Place the rubbish in the disposal location
        print("[Task] Placing the rubbish at:", disposal_pos)
        obs, reward, done = place(env, task, target_pos=disposal_pos)
        if done:
            print("[Task] Task ended after placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()