def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object named 'tomato'
        target_object = 'tomato'
        if target_object not in positions:
            print(f"[Error] {target_object} is not present in the workspace.")
            return

        target_pos = positions[target_object]
        print(f"[Task] Target object '{target_object}' found at: {target_pos}")

        # Check if the robot is handempty before picking
        obs = task.get_observation()
        if not obs.handempty:
            print("[Task] Robot is not handempty, dropping the object if holding.")
            # Assuming we have a drop location, we can drop the object
            drop_location = (0, 0, 0)  # Replace with actual drop location
            print(f"[Task] Dropping object at: {drop_location}")
            obs, reward, done = place(env, task, target_pos=drop_location)
            if done:
                print("[Task] Task ended after dropping the object!")
                return

        # Proceed to pick the target object
        print(f"[Task] Picking object '{target_object}' at: {target_pos}")
        obs, reward, done = pick(
            env,
            task,
            target_pos=target_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Assuming we want to place the object somewhere after picking
        place_location = (1, 1, 0)  # Replace with actual place location
        print(f"[Task] Placing object '{target_object}' at: {place_location}")
        obs, reward, done = place(env, task, target_pos=place_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()