def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the objects based on the provided information
        object_1_pos = positions['plate']
        object_2_pos = positions['item1']
        object_3_pos = positions['item2']

        # Step 1: Move to the position of the first object (plate)
        print("[Task] Moving to the position of the plate.")
        obs, reward, done = move(env, 'rooma', 'rooma')  # Assuming the robot starts in rooma
        if done:
            print("[Task] Task ended after moving to the plate position!")
            return

        # Step 2: Pick the first object (plate)
        print("[Task] Picking up the plate.")
        obs, reward, done = pick(env, 'plate', 'rooma')
        if done:
            print("[Task] Task ended after picking the plate!")
            return

        # Step 3: Move to the position of the second object (item1)
        print("[Task] Moving to the position of item1.")
        obs, reward, done = move(env, 'rooma', 'roomb')  # Move to another room
        if done:
            print("[Task] Task ended after moving to item1 position!")
            return

        # Step 4: Place the first object (plate) at item1's position
        print("[Task] Placing the plate at item1's position.")
        obs, reward, done = place(env, task, target_pos=object_2_pos)
        if done:
            print("[Task] Task ended after placing the plate!")
            return

        # Step 5: Move to the position of the third object (item2)
        print("[Task] Moving to the position of item2.")
        obs, reward, done = move(env, 'roomb', 'roomc')  # Move to another room
        if done:
            print("[Task] Task ended after moving to item2 position!")
            return

        # Step 6: Pick the second object (item2)
        print("[Task] Picking up item2.")
        obs, reward, done = pick(env, 'item2', 'roomc')
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 7: Place the second object (item2) at the original position of the plate
        print("[Task] Placing item2 at the original position of the plate.")
        obs, reward, done = place(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after placing item2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()