def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object named 'tomato' and a location 'plate'
        target_object = 'tomato'
        target_location = 'plate'

        # Check if the target object is in the object list
        if target_object not in positions:
            raise RuntimeError("Target object not found in object list")

        # Get the position of the target object
        object_pos = positions[target_object]

        # Approach the object
        print(f"[Task] Approaching {target_object} at:", object_pos)
        obs, reward, done = move(env, task, 'rooma', 'rooma')  # Assuming the robot is in 'rooma'

        if done:
            print("[Task] Task ended after moving to the object location!")
            return

        # Pick the object
        print(f"[Task] Picking up {target_object}...")
        obs, reward, done = pick(env, target_object, 'rooma')

        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to the target location
        print(f"[Task] Moving to {target_location}...")
        obs, reward, done = move(env, task, 'rooma', target_location)

        if done:
            print("[Task] Task ended after moving to the target location!")
            return

        # Place the object
        print(f"[Task] Placing {target_object} on {target_location}...")
        obs, reward, done = place(env, task, object_pos)

        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()