def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects: ball1 and ball2
        ball1_pos = positions['ball1']
        ball2_pos = positions['ball2']
        robot_pos = positions['robot']

        # Step 1: Move to ball1's position
        print("[Task] Moving to ball1's position:", ball1_pos)
        obs, reward, done = move(env, robot_pos, ball1_pos)
        if done:
            print("[Task] Task ended after moving to ball1's position!")
            return

        # Step 2: Pick up ball1
        print("[Task] Picking up ball1.")
        obs, reward, done = pick(env, 'ball1', ball1_pos)
        if done:
            print("[Task] Task ended after picking up ball1!")
            return

        # Step 3: Move to the drop location (assuming it's at ball2's position)
        print("[Task] Moving to drop location:", ball2_pos)
        obs, reward, done = move(env, ball1_pos, ball2_pos)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 4: Place ball1 at the drop location
        print("[Task] Placing ball1 at drop location.")
        obs, reward, done = place(env, 'ball1', ball2_pos)
        if done:
            print("[Task] Task ended after placing ball1!")
            return

        # Step 5: Move back to the initial position
        print("[Task] Moving back to initial position:", robot_pos)
        obs, reward, done = move(env, ball2_pos, robot_pos)
        if done:
            print("[Task] Task ended after moving back to initial position!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()