def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'tomato1', 'tomato2', and 'plate'
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # Check if the plate is empty before picking up tomatoes
        if obs['plate_empty']:
            print("[Task] Plate is empty, proceeding to pick tomatoes.")
            
            # Pick tomato1
            print("[Task] Manipulating tomato1 at:", tomato1_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato1_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after picking tomato1!")
                return

            # Place tomato1 on the plate
            print("[Task] Placing tomato1 on the plate.")
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos
            )
            if done:
                print("[Task] Task ended after placing tomato1!")
                return

            # Pick tomato2
            print("[Task] Manipulating tomato2 at:", tomato2_pos)
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato2_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after picking tomato2!")
                return

            # Place tomato2 on the plate
            print("[Task] Placing tomato2 on the plate.")
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos
            )
            if done:
                print("[Task] Task ended after placing tomato2!")
                return

        else:
            print("[Task] Plate is not empty, cannot proceed with picking tomatoes.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()