def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects to manipulate
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']

        # Step 1: Approach and pick object_1
        print("[Task] Manipulating object_1 at:", object_1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=object_1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating object_1!")
            return

        # Step 2: Place object_1 in a designated location (e.g., 'location_a')
        print("[Task] Placing object_1 at location_a")
        obs, reward, done = place(
            env,
            task,
            target_pos='location_a'
        )
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # Step 3: Approach and pick object_2
        print("[Task] Manipulating object_2 at:", object_2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=object_2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after manipulating object_2!")
            return

        # Step 4: Place object_2 in a designated location (e.g., 'location_b')
        print("[Task] Placing object_2 at location_b")
        obs, reward, done = place(
            env,
            task,
            target_pos='location_b'
        )
        if done:
            print("[Task] Task ended after placing object_2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()