def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects to manipulate
        object_1_pos = positions['object_1']
        object_2_pos = positions['object_2']
        robot_pos = positions['robot']

        # Step 1: Move to object 1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, robot_pos, object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick object 1
        print("[Task] Picking object_1...")
        obs, reward, done = pick(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to drop location (assuming a drop location is defined)
        drop_location = (1, 1, 0)  # Example drop location
        print("[Task] Moving to drop location:", drop_location)
        obs, reward, done = move(env, object_1_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 4: Place object 1
        print("[Task] Placing object_1...")
        obs, reward, done = place(env, task, target_pos=drop_location)
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # Step 5: Move to object 2
        print("[Task] Moving to object_2 at:", object_2_pos)
        obs, reward, done = move(env, drop_location, object_2_pos)
        if done:
            print("[Task] Task ended after moving to object_2!")
            return

        # Step 6: Pick object 2
        print("[Task] Picking object_2...")
        obs, reward, done = pick(env, task, target_pos=object_2_pos)
        if done:
            print("[Task] Task ended after picking object_2!")
            return

        # Step 7: Move to drop location for object 2
        print("[Task] Moving to drop location for object_2:", drop_location)
        obs, reward, done = move(env, object_2_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location for object_2!")
            return

        # Step 8: Place object 2
        print("[Task] Placing object_2...")
        obs, reward, done = place(env, task, target_pos=drop_location)
        if done:
            print("[Task] Task ended after placing object_2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()