def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'tomato1', 'tomato2', and 'rubbish'
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        rubbish_pos = positions['rubbish']

        # Step 1: Move to tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, 'rooma', 'rooma')  # Assuming both are in the same room for simplicity
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick up tomato1
        print("[Task] Picking up tomato1.")
        obs, reward, done = pick(env, 'tomato1', 'rooma')
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # Step 3: Move to rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, 'rooma', 'roomb')  # Move to another room
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 4: Place tomato1 in rubbish
        print("[Task] Placing tomato1 in rubbish.")
        obs, reward, done = place(env, task, rubbish_pos)
        if done:
            print("[Task] Task ended after placing tomato1 in rubbish!")
            return

        # Step 5: Move to tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, 'roomb', 'roomb')  # Assuming both are in the same room for simplicity
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 6: Pick up tomato2
        print("[Task] Picking up tomato2.")
        obs, reward, done = pick(env, 'tomato2', 'roomb')
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # Step 7: Move to rubbish again
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, 'roomb', 'rooma')  # Move back to the rubbish location
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 8: Place tomato2 in rubbish
        print("[Task] Placing tomato2 in rubbish.")
        obs, reward, done = place(env, task, rubbish_pos)
        if done:
            print("[Task] Task ended after placing tomato2 in rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()