def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the objects to manipulate
        object_to_pick = 'tomato1'
        object_location = positions.get(object_to_pick)

        # Check if the object is present in the object list
        if object_location is None:
            print(f"Error: {object_to_pick} not found in object list.")
            return

        print(f"[Task] Manipulating {object_to_pick} at: {object_location}")

        # Approach and pick the object
        obs, reward, done = pick(
            env,
            task,
            target_pos=object_location,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )

        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Define the drop location (for example, a designated drop zone)
        drop_location = positions.get('drop_zone')  # Assuming 'drop_zone' is defined in positions

        if drop_location is None:
            print("Error: Drop zone not found in object list.")
            return

        print(f"[Task] Placing {object_to_pick} at: {drop_location}")

        # Place the object in the drop zone
        obs, reward, done = place(
            env,
            task,
            target_pos=drop_location
        )

        if done:
            print("[Task] Task completed successfully!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()