def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming the objects are named 'tomato1', 'tomato2', and 'plate'
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']

        # Step 1: Approach and pick the first tomato
        print("[Task] Manipulating tomato1 at:", tomato1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 2: Toss the first tomato onto the plate
        print("[Task] Tossing tomato1 onto the plate at:", plate_pos)
        # Here we would implement the toss logic, but for now, we will simulate it with a place action
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos
        )
        if done:
            print("[Task] Task ended after tossing tomato1!")
            return

        # Step 3: Approach and pick the second tomato
        print("[Task] Manipulating tomato2 at:", tomato2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 4: Toss the second tomato onto the plate
        print("[Task] Tossing tomato2 onto the plate at:", plate_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos
        )
        if done:
            print("[Task] Task ended after tossing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()