def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming we have a plate and multiple tomatoes
        plate_pos = positions['plate']
        tomato_positions = [positions[f'tomato_{i}'] for i in range(1, 4)]  # Assuming 3 tomatoes

        # === Task Execution ===
        for tomato_pos in tomato_positions:
            print(f"[Task] Manipulating tomato at: {tomato_pos}")
            obs, reward, done = pick(
                env,
                task,
                target_pos=tomato_pos,
                approach_distance=0.15,
                max_steps=100,
                threshold=0.01,
                approach_axis='z',
                timeout=10.0
            )
            if done:
                print("[Task] Task ended after picking a tomato!")
                return
            
            print(f"[Task] Placing tomato on plate at: {plate_pos}")
            obs, reward, done = place(
                env,
                task,
                target_pos=plate_pos
            )
            if done:
                print("[Task] Task ended after placing a tomato!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()