def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'rubbish' and 'tomatoes'
        rubbish_pos = positions['rubbish']
        tomatoes_pos = positions['tomatoes']

        # Step 1: Move to the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, 'rooma', 'roomb')  # Example rooms, adjust as necessary
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the tomatoes
        print("[Task] Moving to tomatoes at:", tomatoes_pos)
        obs, reward, done = move(env, 'roomb', 'rooma')  # Example rooms, adjust as necessary
        if done:
            print("[Task] Task ended after moving to tomatoes!")
            return

        # Step 4: Pick up the tomatoes
        print("[Task] Picking up tomatoes at:", tomatoes_pos)
        obs, reward, done = pick(env, task, target_pos=tomatoes_pos)
        if done:
            print("[Task] Task ended after picking up tomatoes!")
            return

        # Step 5: Place the rubbish and tomatoes in the designated area
        print("[Task] Placing rubbish in designated area.")
        obs, reward, done = place(env, task, target_pos='designated_area')  # Adjust as necessary
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

        print("[Task] Placing tomatoes in designated area.")
        obs, reward, done = place(env, task, target_pos='designated_area')  # Adjust as necessary
        if done:
            print("[Task] Task ended after placing tomatoes!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()