def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have 'ball1' and 'ball2' in the environment
        ball1_pos = positions['ball1']
        ball2_pos = positions['ball2']
        robot_pos = positions['robot']

        # Check if the robot is at the initial position
        if not obs.robot_at(robot_pos):
            print("[Task] Moving robot to initial position.")
            move(env, robot_pos, robot_pos)  # Move to the initial position

        # Step 1: Pick up ball1
        print("[Task] Picking up ball1 at:", ball1_pos)
        obs, reward, done = pick(env, task, target_pos=ball1_pos)
        if done:
            print("[Task] Task ended after picking up ball1!")
            return

        # Step 2: Move to the drop location (assuming it's at robot's current position)
        print("[Task] Moving to drop location.")
        move(env, robot_pos, robot_pos)  # Move to the drop location

        # Step 3: Place ball1 at the drop location
        print("[Task] Placing ball1 at drop location.")
        obs, reward, done = place(env, task, target_pos=robot_pos)
        if done:
            print("[Task] Task ended after placing ball1!")
            return

        # Step 4: Pick up ball2
        print("[Task] Picking up ball2 at:", ball2_pos)
        obs, reward, done = pick(env, task, target_pos=ball2_pos)
        if done:
            print("[Task] Task ended after picking up ball2!")
            return

        # Step 5: Move to the drop location again
        print("[Task] Moving to drop location.")
        move(env, robot_pos, robot_pos)  # Move to the drop location

        # Step 6: Place ball2 at the drop location
        print("[Task] Placing ball2 at drop location.")
        obs, reward, done = place(env, task, target_pos=robot_pos)
        if done:
            print("[Task] Task ended after placing ball2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()