def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a single object to manipulate
        object_name = 'ball1'  # Replace with actual object name
        object_pos = positions[object_name]

        # Move to the object's location
        print(f"[Task] Moving to {object_name} at:", object_pos)
        obs, reward, done = move(env, 'rooma', 'rooma')  # Assuming the robot is already in the correct room

        if done:
            print("[Task] Task ended after moving to the object location!")
            return

        # Pick the object
        print(f"[Task] Picking up {object_name} at:", object_pos)
        obs, reward, done = pick(env, task, target_pos=object_pos)

        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to the drop location (assuming 'roomb' is the drop location)
        drop_location = 'roomb'
        print(f"[Task] Moving to drop location: {drop_location}")
        obs, reward, done = move(env, 'rooma', drop_location)

        if done:
            print("[Task] Task ended after moving to the drop location!")
            return

        # Place the object
        print(f"[Task] Placing {object_name} at:", drop_location)
        obs, reward, done = place(env, task, target_pos=drop_location)

        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()