def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have two objects to manipulate
        object_1_pos = positions['ball1']  # Replace with actual object names
        object_2_pos = positions['ball2']  # Replace with actual object names
        robot_pos = positions['robot']      # Replace with actual robot name

        # Step 1: Move to object 1
        print("[Task] Moving to object 1 at:", object_1_pos)
        obs, reward, done = move(env, robot_pos, object_1_pos)
        if done:
            print("[Task] Task ended after moving to object 1!")
            return

        # Step 2: Pick object 1
        print("[Task] Picking object 1 at:", object_1_pos)
        obs, reward, done = pick(env, task, target_pos=object_1_pos)
        if done:
            print("[Task] Task ended after picking object 1!")
            return

        # Step 3: Move to drop location (assuming it's the same as object 2's position)
        print("[Task] Moving to drop location at:", object_2_pos)
        obs, reward, done = move(env, object_1_pos, object_2_pos)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 4: Place object 1 at drop location
        print("[Task] Placing object 1 at:", object_2_pos)
        obs, reward, done = place(env, task, target_pos=object_2_pos)
        if done:
            print("[Task] Task ended after placing object 1!")
            return

        # Step 5: Move back to the initial position (if needed)
        print("[Task] Moving back to initial position at:", robot_pos)
        obs, reward, done = move(env, object_2_pos, robot_pos)
        if done:
            print("[Task] Task ended after returning to initial position!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()