def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'tomato1' and 'tomato2'
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        robot_pos = positions['robot']

        # 1) Move to tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, robot_pos, tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # 2) Pick up tomato1
        print("[Task] Picking up tomato1...")
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Task ended after picking up tomato1!")
            return

        # 3) Move to the drop-off location (assuming it's a predefined location)
        drop_off_pos = positions['drop_off']
        print("[Task] Moving to drop-off location at:", drop_off_pos)
        obs, reward, done = move(env, tomato1_pos, drop_off_pos)
        if done:
            print("[Task] Task ended after moving to drop-off location!")
            return

        # 4) Place tomato1 at the drop-off location
        print("[Task] Placing tomato1...")
        obs, reward, done = place(env, task, target_pos=drop_off_pos)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # 5) Move to tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, drop_off_pos, tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # 6) Pick up tomato2
        print("[Task] Picking up tomato2...")
        obs, reward, done = pick(env, task, target_pos=tomato2_pos)
        if done:
            print("[Task] Task ended after picking up tomato2!")
            return

        # 7) Move back to the drop-off location
        print("[Task] Moving back to drop-off location at:", drop_off_pos)
        obs, reward, done = move(env, tomato2_pos, drop_off_pos)
        if done:
            print("[Task] Task ended after moving back to drop-off location!")
            return

        # 8) Place tomato2 at the drop-off location
        print("[Task] Placing tomato2...")
        obs, reward, done = place(env, task, target_pos=drop_off_pos)
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()