def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # Assuming we have two objects: 'tomato1' and 'tomato2'
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        table_pos = positions['table']  # Assuming there's a table position

        # Check if tomato1 is in the environment
        obs = task.get_observation()
        if not is_object_in_environment(obs, 'tomato1'):
            print("Error: Tomato1 not found in environment.")
            return

        # Step 1: Approach and pick tomato1
        print("[Task] Manipulating tomato1 at:", tomato1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 2: Move to the table
        print("[Task] Moving to the table...")
        obs, reward, done = move(env, task, current_pos=tomato1_pos, target_pos=table_pos)
        if done:
            print("[Task] Task ended during movement to the table!")
            return

        # Step 3: Place tomato1 on the table
        print("[Task] Placing tomato1 on the table...")
        obs, reward, done = place(
            env,
            task,
            target_pos=table_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Check if tomato2 is in the environment
        obs = task.get_observation()
        if not is_object_in_environment(obs, 'tomato2'):
            print("Error: Tomato2 not found in environment.")
            return

        # Step 4: Approach and pick tomato2
        print("[Task] Manipulating tomato2 at:", tomato2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 5: Move to the table again
        print("[Task] Moving to the table...")
        obs, reward, done = move(env, task, current_pos=tomato2_pos, target_pos=table_pos)
        if done:
            print("[Task] Task ended during movement to the table!")
            return

        # Step 6: Place tomato2 on the table
        print("[Task] Placing tomato2 on the table...")
        obs, reward, done = place(
            env,
            task,
            target_pos=table_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


def is_object_in_environment(obs, object_name):
    # Implement a more robust method to check for object presence
    for obj in obs.objects:
        if obj.name == object_name:
            return True
    return False


if __name__ == "__main__":
    run_skeleton_task()