def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'ball' in the environment
        ball_pos = positions['ball']  # Replace 'ball' with the actual object name if different

        # Step 1: Move to the ball's location
        print("[Task] Moving to the ball's location:", ball_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=ball_pos)
        if done:
            print("[Task] Task ended after moving to the ball!")
            return

        # Step 2: Pick up the ball
        print("[Task] Picking up the ball.")
        obs, reward, done = pick(env, task, obj='ball', loc=ball_pos)
        if done:
            print("[Task] Task ended after picking up the ball!")
            return

        # Step 3: Move to the drop-off location (assuming a location named 'drop_zone')
        drop_zone_pos = positions['drop_zone']  # Replace 'drop_zone' with the actual drop-off location name
        print("[Task] Moving to the drop-off location:", drop_zone_pos)
        obs, reward, done = move(env, task, from_room=ball_pos, to_room=drop_zone_pos)
        if done:
            print("[Task] Task ended after moving to the drop-off location!")
            return

        # Step 4: Place the ball down
        print("[Task] Placing the ball down.")
        obs, reward, done = place(env, task, target_pos=drop_zone_pos)
        if done:
            print("[Task] Task ended after placing the ball down!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()