def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'tomato1' at 'location1'
        tomato1_pos = positions['tomato1']
        location1 = 'location1'  # Replace with actual location name if needed

        # 1) Move to the location of the object
        print("[Task] Moving to the location of tomato1 at:", location1)
        obs, reward, done = move(env, 'current_location', location1)
        if done:
            print("[Task] Task ended after moving to location!")
            return

        # 2) Pick the object
        print("[Task] Picking up tomato1 at:", tomato1_pos)
        obs, reward, done = pick(env, task, target_pos=tomato1_pos)
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # 3) Place the object at a new location (assuming 'new_location' is defined)
        new_location = 'new_location'  # Replace with actual new location name
        print("[Task] Placing tomato1 at:", new_location)
        obs, reward, done = place(env, task, target_pos=new_location)
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()