import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import pick, place
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided object list
        tomato1_pos = positions['tomato1']
        plate_pos = positions['plate']

        # === Execute the Plan ===
        # Step 1: Pick tomato1 from the table
        print("[Task] Picking tomato1 from the table.")
        obs, reward, done = pick(
            env,
            task,
            target_pos=tomato1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 2: Place tomato1 on the plate
        print("[Task] Placing tomato1 on the plate.")
        obs, reward, done = place(
            env,
            task,
            target_pos=plate_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

        # Repeat for any additional tomatoes if needed
        # Assuming there are more tomatoes to pick
        for i in range(2, 4):  # Adjust range based on number of tomatoes
            tomato_key = f'tomato{i}'
            if tomato_key in positions:
                tomato_pos = positions[tomato_key]
                
                # Step 3: Pick the next tomato from the table
                print(f"[Task] Picking {tomato_key} from the table.")
                obs, reward, done = pick(
                    env,
                    task,
                    target_pos=tomato_pos,
                    approach_distance=0.15,
                    max_steps=100,
                    threshold=0.01,
                    approach_axis='z',
                    timeout=10.0
                )
                if done:
                    print(f"[Task] Task ended after picking {tomato_key}!")
                    return

                # Step 4: Place the next tomato on the plate
                print(f"[Task] Placing {tomato_key} on the plate.")
                obs, reward, done = place(
                    env,
                    task,
                    target_pos=plate_pos,
                    approach_distance=0.15,
                    max_steps=100,
                    threshold=0.01,
                    approach_axis='z',
                    timeout=10.0
                )
                if done:
                    print(f"[Task] Task completed successfully for {tomato_key}! Reward:", reward)
                    return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")