def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved positions
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_joint_pos = positions['bottom_joint_pos']
        bottom_side_pos = positions['bottom_side_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        middle_joint_pos = positions['middle_joint_pos']
        middle_side_pos = positions['middle_side_pos']
        top_anchor_pos = positions['top_anchor_pos']
        top_joint_pos = positions['top_joint_pos']
        top_side_pos = positions['top_side_pos']
        waypoint1 = positions['waypoint1']

        # === Task Execution Plan ===
        # Step 1: Move to the bottom anchor position
        print("[Task] Moving to bottom anchor position.")
        obs, reward, done = move(env, 'current_position', bottom_anchor_pos)
        if done:
            print("[Task] Task ended after moving to bottom anchor position!")
            return

        # Step 2: Pick the drawer at the bottom anchor position
        print("[Task] Picking the drawer at bottom anchor position.")
        obs, reward, done = pick(env, 'drawer', bottom_anchor_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Rotate the gripper to the desired angle
        print("[Task] Rotating gripper to ninety degrees.")
        obs, reward, done = rotate(env, task, 'ninety_deg')
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 4: Move to the side position of the drawer
        print("[Task] Moving to the side position of the drawer.")
        obs, reward, done = move_to_side(env, 'gripper', 'drawer', bottom_anchor_pos, bottom_side_pos)
        if done:
            print("[Task] Task ended after moving to the side position!")
            return

        # Step 5: Pull the drawer to open it
        print("[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, 'gripper', 'drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 6: Move to the waypoint after opening the drawer
        print("[Task] Moving to waypoint after opening the drawer.")
        obs, reward, done = move(env, 'current_position', waypoint1)
        if done:
            print("[Task] Task ended after moving to waypoint!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()