def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer object and a gripper
        drawer_pos = positions['drawer']  # Replace with actual drawer position key
        gripper_pos = positions['gripper']  # Replace with actual gripper position key

        # Step 1: Move to the side position of the drawer
        print("[Task] Moving to the side position of the drawer.")
        obs, reward, done = move(env, task, target_pos=drawer_pos, max_steps=100)
        if done:
            print("[Task] Task ended after moving to the side position!")
            return

        # Step 2: Rotate the gripper to the correct angle
        print("[Task] Rotating the gripper to the correct angle.")
        obs, reward, done = rotate(env, task, gripper='gripper', from_angle='zero_deg', to_angle='ninety_deg')
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 3: Move to the anchor position of the drawer
        print("[Task] Moving to the anchor position of the drawer.")
        obs, reward, done = move_to_anchor(env, task, gripper='gripper', drawer='drawer', from_pos=drawer_pos, to_pos='anchor_pos')
        if done:
            print("[Task] Task ended after moving to the anchor position!")
            return

        # Step 4: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, task, obj='drawer', room='room', gripper='gripper')
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 5: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, task, gripper='gripper', drawer='drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()