def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the retrieved data
        drawer_pos = positions['drawer']
        gripper_pos = positions['gripper']
        anchor_pos_bottom = positions['anchor_pos_bottom']

        # 1) Move to the side position of the drawer
        print("[Task] Moving to side position of the drawer.")
        obs, reward, done = move(env, task, target_pos=drawer_pos, max_steps=100, threshold=0.01, timeout=10.0)
        if done:
            print("[Task] Task ended after moving to side position!")
            return

        # 2) Rotate the gripper to the correct angle
        print("[Task] Rotating gripper to ninety degrees.")
        obs, reward, done = rotate(env, task, gripper=gripper_pos, from_angle=0, to_angle=90)
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # 3) Move to the anchor position to pick the drawer
        print("[Task] Moving to anchor position to pick the drawer.")
        obs, reward, done = move(env, task, target_pos=anchor_pos_bottom, max_steps=100, threshold=0.01, timeout=10.0)
        if done:
            print("[Task] Task ended after moving to anchor position!")
            return

        # 4) Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, task, obj='drawer', room='room', gripper=gripper_pos)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # 5) Pull the drawer to open it
        print("[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, task, obj='drawer')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()