def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the positions of the drawer and gripper
        drawer_pos = positions['bottom']  # Assuming 'bottom' is the drawer we want to interact with
        gripper_pos = positions['gripper']  # Assuming 'gripper' is the robot's gripper position

        # Step 1: Move the gripper to the side position of the drawer
        print("[Task] Moving gripper to the side position of the drawer.")
        obs, reward, done = move(env, gripper_pos, drawer_pos)  # Move to the side position
        if done:
            print("[Task] Task ended after moving to the side position!")
            return

        # Step 2: Rotate the gripper to the correct angle
        print("[Task] Rotating gripper to the correct angle.")
        obs, reward, done = rotate(env, gripper_pos, 'ninety_deg')  # Rotate to the correct angle
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 3: Move to the anchor position of the drawer
        print("[Task] Moving gripper to the anchor position of the drawer.")
        obs, reward, done = move_to_anchor(env, gripper_pos, drawer_pos, drawer_pos, 'anchor_position')  # Move to anchor position
        if done:
            print("[Task] Task ended after moving to the anchor position!")
            return

        # Step 4: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, task, target_pos=drawer_pos)  # Pick the drawer
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 5: Pull the drawer to open it
        print("[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, gripper_pos, drawer_pos)  # Pull the drawer
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()