import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the parameters for the goal
        gripper = 'gripper'
        drawer = 'bottom'
        anchor_pos = 'anchor-pos-bottom'
        side_pos = 'side-pos-bottom'

        # Execute the plan based on the predefined steps
        try:
            # Step 1: Pick the drawer
            print("[Task] Picking drawer:", drawer)
            obs, reward, done = pick(env, task, anchor_pos, approach_distance=0.15)
            if done:
                print("[Task] Task ended after picking!")
                return
            
            # Step 2: Pull the drawer to open it
            print("[Task] Pulling the drawer to open it.")
            obs, reward, done = pull(env, task, pull_distance=0.2)
            if done:
                print("[Task] Drawer opened successfully!")
                return

        except Exception as e:
            print(f"[Task] An error occurred during task execution: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()