import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use predefined skills
from video import init_video_writers, recording_step, recording_get_observation

# This module is assumed to provide object positions or other info about the environment
from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Plan to open any drawer that is not locked
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']

        # Try to pull the bottom drawer first
        try:
            obs, reward, done = move(env, task, bottom_anchor_pos)
            if done:
                print("[Task] Moved to bottom anchor position.")
            
            obs, reward, done = pull(env, task, pull_distance=0.2, pull_axis='x')
            if done:
                print("[Task] Pulled the bottom drawer successfully.")
        except Exception as e:
            print(f"[Task] Error while pulling the bottom drawer: {e}")

        # Try to pull the middle drawer if necessary
        try:
            obs, reward, done = move(env, task, middle_anchor_pos)
            if done:
                print("[Task] Moved to middle anchor position.")
            
            obs, reward, done = pull(env, task, pull_distance=0.2, pull_axis='x')
            if done:
                print("[Task] Pulled the middle drawer successfully.")
        except Exception as e:
            print(f"[Task] Error while pulling the middle drawer: {e}")

        # Try to pull the top drawer if necessary
        try:
            obs, reward, done = move(env, task, top_anchor_pos)
            if done:
                print("[Task] Moved to top anchor position.")
            
            obs, reward, done = pull(env, task, pull_distance=0.2, pull_axis='x')
            if done:
                print("[Task] Pulled the top drawer successfully.")
        except Exception as e:
            print(f"[Task] Error while pulling the top drawer: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()