import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Setting up the parameters for the required actions
        # We know that we need to pick and then pull the bottom drawer
        drawer = 'bottom'
        anchor_position = positions[f'{drawer}_anchor_pos']  # Using anchor_pos from the retrieved positions
        
        # Step 1: Pick the bottom drawer
        print(f"[Task] Attempting to pick the {drawer} drawer...")
        obs, reward, done = pick(env, task, target_pos=anchor_position, approach_distance=0.15)

        if done:
            print("[Task] Successfully picked the drawer!")
        else:
            print("[Task] Failed to pick the drawer (done=False).")
            return  # Exit if unable to pick

        # Step 2: Pull the bottom drawer
        pull_distance = 0.5  # Set the distance to pull
        pull_axis = 'y'  # Choosing the y-axis for pulling

        print(f"[Task] Attempting to pull the {drawer} drawer...")
        obs, reward, done = pull(env, task, pull_distance=pull_distance, pull_axis=pull_axis)

        if done:
            print("[Task] Successfully opened the drawer!")
        else:
            print("[Task] Failed to open the drawer (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()