import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Assuming existing skill functions like pick, pull, etc. are defined here.

from video import init_video_writers, recording_step, recording_get_observation

# This module is assumed to provide object positions or other info about the environment
from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        bottom = positions['bottom']  # assuming appropriate coordinates
        middle = positions['middle']
        top = positions['top']
        anchor_pos_bottom = positions['bottom_anchor_pos']
        anchor_pos_middle = positions['middle_anchor_pos']
        anchor_pos_top = positions['top_anchor_pos']
        
        # === Task Execution Steps ===
        print("[Task] Step 1: Picking the bottom drawer.")
        obs, reward, done = pick(
            env,
            task,
            target_pos=anchor_pos_bottom,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0
        )
        if done:
            print("[Task] Task ended after picking the bottom drawer!")
            return
        
        print("[Task] Step 2: Pulling the bottom drawer.")
        obs, reward, done = pull(
            env,
            task,
            pull_distance=0.2,  # specify how much to pull
            pull_axis='z',
            max_steps=100,
            threshold=0.01,
            timeout=10.0
        )
        if done:
            print("[Task] Task completed successfully after pulling the drawer!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()