def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer object and a gripper
        drawer = 'drawer1'  # Replace with actual drawer object name
        gripper = 'gripper1'  # Replace with actual gripper object name
        anchor_position = positions['anchor_position']  # Replace with actual anchor position key
        side_position = positions['side_position']  # Replace with actual side position key

        # Step 1: Move to the anchor position
        print("[Task] Moving to anchor position.")
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], anchor_position)
        if done:
            print("[Task] Task ended after moving to anchor position!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, anchor_position, gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Rotate the gripper to the side position
        print("[Task] Rotating gripper to side position.")
        obs, reward, done = rotate(env, task, side_position)
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Step 4: Move to the side position
        print("[Task] Moving to side position.")
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], side_position)
        if done:
            print("[Task] Task ended after moving to side position!")
            return

        # Step 5: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()