def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer object and a gripper
        drawer = 'drawer1'  # Replace with actual drawer object name
        gripper = 'gripper1'  # Replace with actual gripper object name
        anchor_pos = 'anchor_pos1'  # Replace with actual anchor position
        side_pos = 'side_pos1'  # Replace with actual side position

        # Step 1: Move gripper to the anchor position
        print("[Task] Moving gripper to anchor position.")
        obs, reward, done = move_to_anchor(gripper, drawer, positions[gripper], anchor_pos)
        if done:
            print("[Task] Task ended after moving to anchor position!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(gripper, drawer, anchor_pos)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Rotate the gripper to the correct angle
        print("[Task] Rotating gripper to ninety degrees.")
        obs, reward, done = rotate(env, task, target_quat=[0, 0, np.sin(np.pi/4), np.cos(np.pi/4)])  # Example quaternion for 90 degrees
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Step 4: Move to the side position
        print("[Task] Moving gripper to side position.")
        obs, reward, done = move_to_side(gripper, drawer, anchor_pos, side_pos)
        if done:
            print("[Task] Task ended after moving to side position!")
            return

        # Step 5: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()